#ifndef SIMULATION_H
#define SIMULATION_H

#include "../common/structs.h"
#include "../common/vector.h"
#include <time.h>


void run_simulation();

#define BULLET_OBJ main_scene->models[1]
#define CANNON_OBJ main_scene->models[2]
#define MARKER_OBJ main_scene->models[3]

#define MASS_OBJ main_scene->models[1]
#define SPRING_OBJ main_scene->models[2]


#define T_CANNON 0
#define T_SPRING 1
#define T_BALLS 2
#define T_BEAD 3

void add_states(state *dest, state *s1, state *s2);
void multiply_state(state *dest, state *s, double d);
void start_sim();
void change_solver();
void reset_sim();
void recalc_cannon();
void capture_state(state *s);
void save_ball_data(int index1, int index2, double index3, double index4, double value);

void run_cannon();
void run_spring();
void run_bead();

void add_bead();
void remove_bead();
void add_ball();
void remove_ball();
void run_balls();
void setup_rects();
void setup_bead();

void reset_cannon_state();
void reset_spring_state();
void reset_bead_state();
void fire_cannon();
void release_spring();
void release_bead();

void setup_sim();

typedef struct
{
	point pos;
	list objects;
} octant;

#endif /* SIMULATION_H */
